<?php 

header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.
include ('includes/header.php');

// Função para fazer o upload do arquivo
function uploadFile($file, $existingFileName = null) {
    if ($file["size"] == 0) {
        // Nenhum arquivo selecionado, retornar null
        return null;
    }
    
    $targetDir = "api/logo/";
    
    // Obter a extensão do arquivo
    $imageFileType = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
    
    // Usar o nome de arquivo existente se fornecido, senão gerar um nome único
    if ($existingFileName) {
        $uniqueFileName = $existingFileName;
    } else {
        $currentDateTime = date('YmdHis');
        $uniqueFileName = $currentDateTime . '.' . $imageFileType;
    }
    
    // Caminho completo para o arquivo de destino
    $targetFile = $targetDir . $uniqueFileName;
    
    $uploadOk = 1;

    // Permitir apenas alguns formatos de arquivo
    if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
        echo "Desculpe, apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
        $uploadOk = 0;
    }

    // Se tudo estiver ok, tenta fazer o upload do arquivo
    if ($uploadOk == 0) {
        echo "Desculpe, seu arquivo não foi enviado.";
    } else {
        if (move_uploaded_file($file["tmp_name"], $targetFile)) {
            return $targetFile; // Retorna o caminho do arquivo salvo
        } else {
            echo "Desculpe, ocorreu um erro ao fazer o upload do arquivo.";
            return null;
        }
    }
}

// Função para deletar o arquivo de imagem
function deleteFile($url) {
    if(file_exists($url)) {
        unlink($url);
    }
}

// Nome da tabela
$table_name = "ads";

// Variável do arquivo atual
$base_file = basename($_SERVER["SCRIPT_NAME"]);

// Criar tabela se não existir
$adb3->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, title VARCHAR(100), caminho TEXT)");

// Consulta à tabela
$res = $adb3->query("SELECT * FROM {$table_name}");

// Consulta de atualização
@$resU = $adb3->query("SELECT * FROM {$table_name} WHERE id='{$_GET['update']}'");
@$rowU = $resU->fetchArray();

if (isset($_POST['submitU'])) {
    $file_path = null;
    $newFileUploaded = !empty($_FILES["fileToUpload"]["name"]);
    
    if ($newFileUploaded) {
        // Obter o URL do arquivo atual
        $updateQuery = $adb3->query("SELECT caminho FROM {$table_name} WHERE id={$_POST['id']}");
        $updateRow = $updateQuery->fetchArray();
        $currentFileUrl = $updateRow['caminho'];
        $existingFileName = basename($currentFileUrl);

        // Fazer o upload do novo arquivo com o nome do arquivo existente
        $file_path = uploadFile($_FILES["fileToUpload"], $existingFileName);

        // Se um novo arquivo foi enviado, excluir o arquivo atual
        if ($file_path !== null && $file_path != $currentFileUrl) {
            deleteFile($currentFileUrl);
        }
    }
    
    if (isset($_POST['id']) && (isset($_POST['title']) || $file_path !== null)) {
        $title = isset($_POST['title']) ? $_POST['title'] : $rowU['title'];
        $caminho = $file_path !== null ? $file_path : $updateRow['caminho'];
        
        $adb3->exec("UPDATE {$table_name} SET title='{$title}', caminho='{$caminho}' WHERE id='{$_POST['id']}'");
        $adb3->close();
        echo "<script>window.location.href='logo.php';</script>";
        exit;
    } else {
        echo "Nenhum dado enviado.";
    }
}

// Função para adicionar um novo registro
if (isset($_POST['submit'])) {
    $file_path = null;
    if (!empty($_FILES["fileToUpload"]["name"])) {
        $file_path = uploadFile($_FILES["fileToUpload"]);
    }
    if ($file_path !== null || isset($_POST['title'])) {
        $title = isset($_POST['title']) ? $_POST['title'] : "";
        $caminho = $file_path !== null ? $file_path : "";
        
        $adb3->exec("INSERT INTO {$table_name}(title, caminho) VALUES('{$title}', '{$caminho}')");
        echo "<script>window.location.href='logo.php';</script>";
        exit;
    } else {
        echo "Nenhum dado enviado.";
    }
}

// Deletar registro
if (isset($_GET['delete'])) {
    // Busca o URL do arquivo a ser deletado
    $deleteQuery = $adb3->query("SELECT caminho FROM {$table_name} WHERE id={$_GET['delete']}");
    $deleteRow = $deleteQuery->fetchArray();
    $deleteUrl = $deleteRow['caminho'];
    
    // Deleta o arquivo de imagem correspondente
    deleteFile($deleteUrl);
    
    // Deleta o registro do banco de dados
    $adb3->exec("DELETE FROM {$table_name} WHERE id={$_GET['delete']}");
    
    // Redireciona para a página principal
    echo "<script>window.location.href='logo.php';</script>";
    exit;
}

?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">CONFIRMAR</h2>
            </div>
            <div class="modal-body" style="color: white;">
                QUER MESMO DELETAR?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">CANCELAR</button>
                <a style="color: white;" class="btn btn-danger btn-ok">DELETAR</a>
            </div>
        </div>
    </div>
</div>

<?php
if (isset($_GET['create'])) {

// Formulário de criação
?>
<div class="card radius-10">
    <center>
        <h2 class="colorboard"></i>NOVO LOGO</h2>
    </center>
    <div class="card radius-10">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <input class="form-control" type="text" name="title">
                    <label>NOME DO LOGO</label>
                </div>
                <div class="form-group">
                    <input type="file" name="fileToUpload" id="fileToUpload">
                </div>
                <div class="col-12">
                    <button type="submit" name="submit" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
} else if (isset($_GET['update'])) { 

// Formulário de atualização
?>
<div class="card radius-10">
    <center>
        <h2 class="colorboard"></i>EDITAR LOGO</h2>
    </center>
    <div class="card radius-10">
        <div class="card-header">
            </center>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" class="form-control" name="id" value="<?=$_GET['update'] ?>">
                <div class="user-box">
                    <input type="text" name="title" class="form-control" value="<?=$rowU['title'] ?>">
                    <label>NOME DO LOGO</label>
                </div>
                <div class="user-box">
                    <input type="file" name="fileToUpload" id="fileToUpload">
                    <br><br>
                </div>
                <div class="col-12">
                    <button type="submit" name="submitU" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
} else {

// Tabela principal
?>
<div class="card radius-10">
    <center>
        <h1 class="colorboard"></i> LOGO APP</h1>
        <br>
   
        <br>
        <a id="button" href="./<?php echo $base_file ?>?create" class="btn btn-primary">NOVO</a>
    </center>
    <br>
    <div class="table-responsive">
        <table class="table table-striped table-sm">
            <thead style="color:grey!important">
                <tr>
                    <th>ID</th>
                    <th>NOME</th>
                    <th>PRÉVIA</th>
                    <th>EDITAR&nbsp;&nbsp;&nbsp;DELETAR</th>
                </tr>
            </thead>
            <?php while ($row = $res->fetchArray()) { ?>
            <tbody>
                <tr>
                    <td><?=$row['id'] ?></td>
                    <td><?=$row['title'] ?></td>
                    <td>
                        <?php if (strpos($row['caminho'], '.jpg') !== false || strpos($row['caminho'], '.jpeg') !== false || strpos($row['caminho'], '.png') !== false || strpos($row['caminho'], '.gif') !== false) { ?>
                            <img src="<?=$row['caminho']?>" width="100px"/>
                        <?php } ?>
                    </td>
                    <td>
                    <a href="./<?php echo $base_file ?>?update=<?= $row['id'] ?>" class="btn btn-warning">EDITAR</a>
                    <a href="./<?php echo $base_file ?>?delete=<?= $row['id'] ?>" class="btn btn-danger">DELETAR</a>  
                    </td>
                </tr>
            </tbody>
            <?php } ?>
        </table>
    </div>
</div>

<?php } ?>

<?php include ('includes/footer.php'); ?>
<script type="text/javascript">
// Alerta de sucesso
$("#success-alert").fadeTo(2000, 500).slideUp(500, function(){
    $("#success-alert").alert('close');
});

// Modal de confirmação de deleção
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>
</body>
</html>
